/*---------------------------------------------------------------------------------
Name               : keytouch-editor.h
Author             : Marvin Raaijmakers
Description        : The main header file of keytouch-editor
Date of last change: 12-Nov-2005

    Copyright (C) 2005 Marvin Raaijmakers

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    You can contact me at: marvinr(at)users(dot)sf(dot)net
    (replace (at) by @ and (dot) by .)
-----------------------------------------------------------------------------------*/
#ifndef TRUE
#	define TRUE	1
#	define FALSE	0
	typedef int Boolean; 
#endif


#define ACPI_SOCKETFILE	"/var/run/acpid.socket"

#define SYNTAX_VERSION	"1.1"		/* The syntax version of the file this program produces */
#define DATE_FORMAT	"%d-%m-%Y"

#define EQUAL	0

#define MAX_MANUFACTURER_LEN	99
#define MAX_MODEL_LEN		99
#define MAX_SCANCODE_LEN	3
#define MAX_KEY_NAME_LEN	99
#define MAX_KEYCODE_LEN		40
#define MAX_PROGRAM_LEN		99
#define MAX_PLUGIN_NAME_LEN	99
#define MAX_PLUGIN_FUNCTION_LEN	99
#define MAX_AUTHOR_LEN		99
#define MAX_DATE_LEN		99


/****** Functions in config.c ******/
extern void get_key_list (	XmlContent	*keyboard_element,
				XmlDocument	*document,
				char		*device_name,
				int		acpi_socket,
				Boolean		is_i8042,
				Boolean		is_acpi  );
extern void get_keyboard_name (	XmlContent	*keyboard_element,
				XmlDocument	*document           );
extern void get_file_info (	XmlContent	*keyboard_element,
				XmlDocument	*document           );

/****** Functions in device.c ******/
extern Boolean print_device_info (int event_device);
extern unsigned int get_scancode (int event_device);
extern int get_bus_type (int event_device);

/****** Functions in acpi_socket.c ******/
extern char *read_eventdescr (int fd);
